<?php
// worker_scan.php
// Run this from CLI: php worker_scan.php
// For production, run as a systemd service or supervisord process.

$db = new PDO('sqlite:' . __DIR__ . '/scanner.db');
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Get one pending job
$stmt = $db->query("SELECT * FROM jobs WHERE status='pending' ORDER BY created_at ASC LIMIT 1");
$job = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$job) {
    echo "No pending jobs\n";
    exit;
}

$job_id = $job['id'];
$target = $job['target'];

$db->prepare("UPDATE jobs SET status='processing' WHERE id=:id")->execute([':id'=>$job_id]);

function http_get($url) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 8);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_USERAGENT, 'AstraScanner/1.0');
    $res = curl_exec($ch);
    $info = curl_getinfo($ch);
    $err = curl_error($ch);
    curl_close($ch);
    return ['body'=>$res, 'info'=>$info, 'err'=>$err];
}

function save_result($db, $job_id, $check_name, $ok, $value, $raw='') {
    $stmt = $db->prepare("INSERT INTO results (job_id, check_name, ok, value, raw_response, created_at) VALUES (:jid, :cn, :ok, :val, :raw, :c)");
    $stmt->execute([
        ':jid'=>$job_id, ':cn'=>$check_name, ':ok'=>$ok ? 1 : 0, ':val'=>$value, ':raw'=>$raw, ':c'=>time()
    ]);
}

// CHECK 1: HTTP status and body
$r = http_get($target);
$http_code = $r['info']['http_code'] ?? 0;
$ok = ($http_code >= 200 && $http_code < 400);
save_result($db, $job_id, 'http_status', $ok, strval($http_code), substr($r['body'] ?? '', 0, 2000));

// CHECK 2: contains 'gpt' or 'openai' (case-insensitive)
$body = $r['body'] ?? '';
$contains = (stripos($body, 'gpt') !== false) || (stripos($body, 'openai') !== false);
save_result($db, $job_id, 'contains_gpt', $contains, $contains ? 'yes' : 'no', '');

// CHECK 3: response time (ms)
$time_ms = intval( ($r['info']['total_time'] ?? 0) * 1000 );
save_result($db, $job_id, 'response_time_ms', 1, strval($time_ms), '');

// Mark done
$db->prepare("UPDATE jobs SET status='done' WHERE id=:id")->execute([':id'=>$job_id]);

echo "Processed job $job_id\n";
