<?php
// init_db.php
// Run once from CLI: php init_db.php
try {
    $db = new PDO('sqlite:' . __DIR__ . '/scanner.db');
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $db->exec("
    CREATE TABLE IF NOT EXISTS jobs (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      target TEXT,
      params TEXT,
      status TEXT,
      created_at INTEGER
    );
    ");
    $db->exec("
    CREATE TABLE IF NOT EXISTS results (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      job_id INTEGER,
      check_name TEXT,
      ok INTEGER,
      value TEXT,
      raw_response TEXT,
      created_at INTEGER
    );
    ");
    echo \"DB initialized at \" . __DIR__ . \"/scanner.db\\n\";
} catch (Exception $e) {
    echo \"Error: \" . $e->getMessage() . \"\\n\";
}
