<?php
// astra_frontend.php
// This is the frontend page. Place it under your webroot. It uses fetch() to call api/scan.php and api/result.php.
// Remember to change AUTH_TOKEN in the JS below to match api files.

?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Cesbo Astra Scanner - Real</title>
<style>
body{font-family:Segoe UI,Helvetica,Arial,sans-serif;background:#0f0f1a;color:#e0e0e0;margin:0;padding:20px}
.container{max-width:900px;margin:40px auto;background:linear-gradient(135deg,#071426 0%, #0a1220 100%);padding:24px;border-radius:12px;box-shadow:0 8px 30px rgba(0,0,0,0.6)}
h1{text-align:center;color:#00e6ff;margin-bottom:18px}
.input-group{display:flex;gap:10px;margin-bottom:18px}
input[type="text"]{flex:1;padding:12px;border-radius:8px;border:1px solid #223344;background:#08121a;color:#e6f7ff}
button{padding:10px 18px;border-radius:8px;border:none;background:#00bcd4;color:#012;cursor:pointer;font-weight:700}
.results{margin-top:18px;padding:14px;border-radius:8px;background:#061226;border:1px solid #123}
.result-item{padding:8px;border-bottom:1px solid #0b2940}
.small{font-size:13px;color:#8fb0c0}
</style>
</head>
<body>
<div class="container">
  <h1>Cesbo Astra Scanner - Real</h1>
  <div class="input-group">
    <input id="target" type="text" placeholder="https://example.com or https://api.example.com/gpt">
    <button id="startBtn">Iniciar Escaneo</button>
  </div>
  <div id="status" class="small">Estado: listo</div>
  <div class="results" id="results"></div>
</div>

<script>
const AUTH_TOKEN = 'REPLACE_WITH_STRONG_TOKEN_HERE'; // <- Cambia esto

document.getElementById('startBtn').addEventListener('click', async ()=>{
  const target = document.getElementById('target').value.trim();
  if(!target){ alert('Escribe un target válido'); return; }
  document.getElementById('status').textContent = 'Estado: creando job...';
  try {
    const resp = await fetch('/api/scan.php', {
      method: 'POST',
      headers: {
        'Content-Type':'application/json',
        'Authorization': 'Bearer ' + AUTH_TOKEN
      },
      body: JSON.stringify({target})
    });
    const data = await resp.json();
    if(!data.job_id){ alert('Error: ' + JSON.stringify(data)); document.getElementById('status').textContent='Estado: error'; return; }
    const jobId = data.job_id;
    document.getElementById('status').textContent = 'Estado: job creado #' + jobId + ' — escaneando...';
    pollResult(jobId);
  } catch (e) {
    console.error(e);
    alert('Error al crear job');
    document.getElementById('status').textContent='Estado: error';
  }
});

let polling = null;
async function pollResult(jobId){
  document.getElementById('results').innerHTML = '';
  polling = setInterval(async ()=>{
    try {
      const r = await fetch('/api/result.php?job_id=' + jobId, {
        headers: {'Authorization': 'Bearer ' + AUTH_TOKEN}
      });
      const j = await r.json();
      if(j.error){ console.error(j); clearInterval(polling); document.getElementById('status').textContent='Estado: error'; return; }
      renderResults(j);
      if(j.job && j.job.status === 'done'){
        clearInterval(polling);
        document.getElementById('status').textContent = 'Estado: terminado (job #' + jobId + ')';
      } else {
        document.getElementById('status').textContent = 'Estado: en progreso (job #' + jobId + ')';
      }
    } catch (e) {
      console.error(e);
      clearInterval(polling);
      document.getElementById('status').textContent='Estado: error';
    }
  }, 2000);
}

function renderResults(payload){
  const resultsDiv = document.getElementById('results');
  resultsDiv.innerHTML = '';
  const job = payload.job;
  const rs = payload.results || [];
  const h = document.createElement('div');
  h.className = 'result-item';
  h.innerHTML = '<strong>Target:</strong> ' + (job.target || '') + ' <span class="small">status: ' + (job.status||'') + '</span>';
  resultsDiv.appendChild(h);
  rs.forEach(r=>{
    const d = document.createElement('div');
    d.className = 'result-item';
    d.innerHTML = '<strong>' + r.check_name + '</strong> — ok: ' + (r.ok==1 ? '✔' : '✖') + ' — ' + (r.value || '') + '<div class="small">'+(r.raw_response || '')+'</div>';
    resultsDiv.appendChild(d);
  });
}
</script>
</body>
</html>
