<?php
// api/scan.php
// Simple scanner job creator.
// Requirements: PHP 7.4+, PDO_SQLITE enabled.
// IMPORTANT: Replace $AUTH_TOKEN with a strong secret and use HTTPS in production.

header('Content-Type: application/json; charset=utf-8');

$AUTH_TOKEN = 'REPLACE_WITH_STRONG_TOKEN_HERE';

// Simple Authorization: Bearer <token>
$headers = getallheaders();
$auth = $headers['Authorization'] ?? ($headers['authorization'] ?? null);
if (!$auth || $auth !== "Bearer $AUTH_TOKEN") {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
if (!$input || empty($input['target'])) {
    http_response_code(400);
    echo json_encode(['error' => 'target required']);
    exit;
}

$target = trim($input['target']);

// Basic validation: only allow http/https URLs and reasonable length
if (!preg_match('#^https?://[A-Za-z0-9\.\-:_/]+$#', $target) || strlen($target) > 1000) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid target']);
    exit;
}

// Prevent local addresses (simple check). Extend as needed.
$disallowed = ['127.0.0.1', 'localhost', '::1', '169.254.', '10.', '172.16.', '172.31.', '192.168.'];
foreach ($disallowed as $d) {
    if (stripos($target, $d) !== false) {
        http_response_code(400);
        echo json_encode(['error' => 'Target not allowed']);
        exit;
    }
}

try {
    $db = new PDO('sqlite:' . __DIR__ . '/../scanner.db');
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $stmt = $db->prepare('INSERT INTO jobs (target, params, status, created_at) VALUES (:t, :p, :s, :c)');
    $stmt->execute([
        ':t' => $target,
        ':p' => json_encode($input['params'] ?? new StdClass()),
        ':s' => 'pending',
        ':c' => time()
    ]);

    $job_id = $db->lastInsertId();
    echo json_encode(['ok' => true, 'job_id' => $job_id]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'server error', 'msg' => $e->getMessage()]);
}
