<?php
// api/result.php
header('Content-Type: application/json; charset=utf-8');

$AUTH_TOKEN = 'REPLACE_WITH_STRONG_TOKEN_HERE';
$headers = getallheaders();
$auth = $headers['Authorization'] ?? ($headers['authorization'] ?? null);
if (!$auth || $auth !== "Bearer $AUTH_TOKEN") {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

$job_id = intval($_GET['job_id'] ?? 0);
if (!$job_id) {
    http_response_code(400);
    echo json_encode(['error' => 'job_id required']);
    exit;
}

try {
    $db = new PDO('sqlite:' . __DIR__ . '/../scanner.db');
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $jobs = $db->prepare("SELECT id, target, params, status, created_at FROM jobs WHERE id = :id");
    $jobs->execute([':id'=>$job_id]);
    $job = $jobs->fetch(PDO::FETCH_ASSOC);

    if (!$job) {
        http_response_code(404);
        echo json_encode(['error'=>'job not found']);
        exit;
    }

    $res = $db->prepare("SELECT check_name, ok, value, raw_response, created_at FROM results WHERE job_id = :id ORDER BY id ASC");
    $res->execute([':id'=>$job_id]);
    $results = $res->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(['job'=>$job, 'results'=>$results]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error'=>'server error', 'msg'=>$e->getMessage()]);
}
