
# Astra Scanner - Deployment Package

Contenido:
- /api/scan.php       -> API endpoint to create scan job (POST)
- /api/result.php     -> API endpoint to fetch results (GET ?job_id=)
- /worker_scan.php    -> CLI worker that processes one job (run via cron/systemd)
- /init_db.php        -> Script to create scanner.db (run once)
- /astra_frontend.php -> Frontend page (replace your current astra page with this)
- /scanner.db         -> Created after running init_db.php

## Requisitos
- PHP 7.4 o superior
- Extensión PDO_SQLITE (o adaptar a MySQL si prefieres)
- Web server (Apache/Nginx) configurado para servir los archivos (asegúrate que /api esté accesible)
- HTTPS recomendado

## Pasos de instalación (rápidos)
1. Subir todos los archivos al directorio de tu servidor, por ejemplo `/var/www/astra/`.
2. Desde consola en el mismo directorio ejecutar:
   ```
   php init_db.php
   ```
   Esto creará `scanner.db`.
3. Edita `api/scan.php`, `api/result.php` y `astra_frontend.php` cambiando `REPLACE_WITH_STRONG_TOKEN_HERE` por una cadena secreta fuerte.
4. Asegúrate que el servidor web tenga permiso de lectura/escritura en `scanner.db`.
   ```
   chown www-data:www-data scanner.db
   chmod 640 scanner.db
   ```
5. Ejecuta el worker manualmente para procesar jobs:
   ```
   php worker_scan.php
   ```
   Para producción se recomienda crear un servicio systemd o usar supervisord. Ejemplo systemd abajo.

## Ejemplo systemd unit (crear /etc/systemd/system/astra-worker.service)
```
[Unit]
Description=Astra Scanner Worker
After=network.target

[Service]
Type=simple
User=www-data
WorkingDirectory=/var/www/astra
ExecStart=/usr/bin/php /var/www/astra/worker_scan.php
Restart=on-failure
RestartSec=5

[Install]
WantedBy=multi-user.target
```
Luego:
```
systemctl daemon-reload
systemctl enable --now astra-worker.service
```

## Seguridad y notas
- No expongas las APIs públicamente sin autenticación fuerte.
- Añade validación adicional para evitar SSRF y accesos a direcciones internas.
- Limita tamaño de respuestas almacenadas y registra actividad.
- Si vas a integrar con APIs de modelos (OpenAI u otras) guarda tokens en variables de entorno y nunca en el frontend.

